*** Replication Materials for Adler and Ansell 2019

*** Table One: Local Authority Level)


use "/Users/ben.ansell/Dropbox/Adler and Ansell/Populism WEP/Brexit/Correct Data/Combined_Adler_Ansell_Brexit_LAD.dta"


reg pct_leave  log_median_lad_price   i.region_no  if year==2015,  cluster(region)
eststo b1

reg pct_leave  log_median_lad_price    jsa_rate_  weekly_pay weekly_pay_2015_1997 manuf_total  change_wc change_mc pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth i.region_no  if year==2015,  cluster(region)
eststo b2

reg pct_leave  med_house_price_pc_2015_1996  i.region_no     if year==2015,  cluster(region)
eststo b3

reg pct_leave  med_house_price_pc_2015_1996    jsa_rate_  weekly_pay weekly_pay_2015_1997 manuf_total  change_wc change_mc pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth i.region_no  if year==2015,  cluster(region)
eststo b4

reg pct_leave log_median_lad_price  med_house_price_pc_2015_1996  i.region_no     if year==2015,  cluster(region)
eststo b5

reg pct_leave log_median_lad_price med_house_price_pc_2015_1996    jsa_rate_  weekly_pay weekly_pay_2015_1997  manuf_total  change_wc change_mc pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth i.region_no  if year==2015,  cluster(region)
eststo b6

esttab b1 b2 b3 b4 b5 b6 using wep_brexit_.rtf,  keep (log_median_lad_price med_house_price_pc_2015_1996    jsa_rate_   weekly_pay weekly_pay_2015_1997  manuf_total  change_wc change_mc pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth) ///
order(log_median_lad_price med_house_price_pc_2015_1996    jsa_rate_   weekly_pay  weekly_pay_2015_1997 manuf_total  change_wc change_mc pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth) replace star(* 0.10 ** 0.05 *** 0.01) b(2) se(2)

*------------------

*** Table Two: Ward Data

  
use  "Adler_Ansell_Brexit_ward_2015.dta", clear


reg ward_leave_pct log_median_ward_price  ward_total_votes if year==2015&log_median_ward_price<15, cluster(oslaua)
eststo b1
reg ward_leave_pct log_median_ward_price log_median_lad_price  ward_total_votes if year==2015&log_median_ward_price<15, cluster(oslaua)
eststo b2
reg ward_leave_pct log_median_ward_price ward_total_votes i.lad_code if year==2015&log_median_ward_price<15, cluster(oslaua)
eststo b3
reg ward_leave_pct  med_ward_house_price_pc_ch_2015 ward_total_votes if year==2015&log_median_ward_price<15, cluster(oslaua)
eststo b4
reg ward_leave_pct  med_ward_house_price_pc_ch_2015 ward_total_votes i.lad_code if year==2015&log_median_ward_price<15, cluster(oslaua)
eststo b5
reg ward_leave_pct ward_ptile_yr  ward_total_votes if year==2015&log_median_ward_price<15, cluster(oslaua)
eststo b6
reg ward_leave_pct ward_ptile_yr  ward_total_votes i.lad_code  if year==2015&log_median_ward_price<15, cluster(oslaua)
eststo b7

  esttab b1 b2 b3 b4 b5 b6 b7 using "brexit_ward_wep.rtf", replace se(2) label b(2) nomtitles  ///
  keep( log_median_ward_price  med_ward_house_price_pc_ch_2015 log_median_lad_price ward_ptile_yr  ward_total_votes ) ///
  order ( log_median_ward_price log_median_lad_price  med_ward_house_price_pc_ch_2015  ward_ptile_yr  ward_total_votes ) star(* 0.10 ** 0.05 *** 0.01)

*------------------

*** Table 3 British Election Study

* Using correct Wave 8 v2.3 data with intention and reported vote

use "Ansell_Adler_BES_W8_2_3_correct.dta", clear

xtlogit bes_brexit_intention hh_income gender c.age##c.age edlevel c.ownhouse c.log_median_la i.region_no, re i(lad_code) 
eststo w1

xtlogit bes_brexit_intention hh_income gender c.age##c.age edlevel c.ownhouse##c.log_median_la i.region_no, re i(lad_code) 
eststo w2
xtlogit bes_brexit_intention hh_income gender c.age##c.age edlevel c.ownhouse c.log_median_la  jsa_rate_ weekly_pay    pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth  i.region_no, re i(lad_code) 
eststo w3
xtlogit bes_brexit_intention hh_income gender c.age##c.age edlevel c.ownhouse##c.log_median_la  jsa_rate_ weekly_pay    pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth  i.region_no, re i(lad_code) 
eststo w4

xtlogit bes_brexit_vote_reported hh_income gender c.age##c.age edlevel c.ownhouse c.log_median_la i.region_no, re i(lad_code) 
eststo w5
xtlogit bes_brexit_vote_reported hh_income gender c.age##c.age edlevel c.ownhouse##c.log_median_la i.region_no, re i(lad_code) 
eststo w6
xtlogit bes_brexit_vote_reported hh_income gender c.age##c.age edlevel c.ownhouse c.log_median_la  jsa_rate_ weekly_pay    pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth  i.region_no, re i(lad_code) 
eststo w7
xtlogit bes_brexit_vote_reported hh_income gender c.age##c.age edlevel c.ownhouse##c.log_median_la  jsa_rate_ weekly_pay    pct_over65_  pct_under15_ electorate_10k prop_non_uk_2015 non_uk_abs_growth  i.region_no, re i(lad_code) 
eststo w8

esttab w1 w2 w3 w4 w5 w6 w7 w8  using "bes_brexit_adler_ansell.rtf", replace b(2) se(2) label  nomtitles star(* 0.10 ** 0.05 *** 0.01) drop(*.region_no)

xtlogit bes_brexit_vote_reported hh_income gender c.age##c.age edlevel c.ownhouse##c.log_median_la i.region_no, re i(lad_code) 
margins, at(log_median_lad_price = (11.5 (.5) 13.5) ownhouse = (0 1) )
marginsplot
graph save Graph "/Users/ben.ansell/Dropbox/Adler and Ansell/Populism WEP/Brexit/Correct Data/Model_6_interaction_BES.gph", replace


** Fixed effects models (appendix?) - note very similar coeffcients to models 4 and 8

xtlogit bes_brexit_intention hh_income gender c.age##c.age edlevel ownhouse c.ownhouse#c.log_median_la , fe i(lad_code)
eststo w1 
xtlogit bes_brexit_vote_reported hh_income gender c.age##c.age edlevel ownhouse  c.ownhouse#c.log_median_la , fe i(lad_code) 
eststo w2
esttab w1 w2  using "bes_brexit_fixed_fx.rtf", replace b(2) se(2) label  nomtitles star(* 0.10 ** 0.05 *** 0.01) 


*------------------

* Table 4 - French Presidential Election

use "Adler_Ansell_French_Election.dta", clear


**S14 is occupation, S6 educationw

*** Regressions

*** Macron Vote Second Round

logit vote_macron_r2  age hh_income gender S6 c.log_maison c.homeowner rel_attend   i.S14 [pweight=w6], cluster(departement_name)
eststo m1
logit vote_macron_r2  age hh_income gender S6 c.log_maison c.homeowner rel_attend left_right   i.S14 [pweight=w6], cluster(departement_name)
eststo m2
logit vote_macron_r2  age hh_income gender S6 c.index_2017_2007 c.homeowner rel_attend   i.S14 [pweight=w6], cluster(departement_name)
eststo m3
logit vote_macron_r2  age hh_income gender S6 c.index_2017_2007 c.homeowner rel_attend left_right   i.S14 [pweight=w6], cluster(departement_name)
eststo m4



*** LePen Vote Second Round

logit vote_lepen_r2  age hh_income gender S6 c.log_maison c.homeowner rel_attend   i.S14 [pweight=w6], cluster(departement_name)
eststo m5
logit vote_lepen_r2  age hh_income gender S6 c.log_maison c.homeowner rel_attend left_right   i.S14 [pweight=w6], cluster(departement_name)
eststo m6
logit vote_lepen_r2  age hh_income gender S6 c.index_2017_2007 c.homeowner rel_attend   i.S14 [pweight=w6], cluster(departement_name)
eststo m7
logit vote_lepen_r2  age hh_income gender S6 c.index_2017_2007 c.homeowner rel_attend left_right   i.S14 [pweight=w6], cluster(departement_name)
eststo m8


esttab m1 m2 m3 m4 m5 m6 m7 m8 using french_2017.rtf, keep (age hh_income S6  gender log_maison index_2017_2007 homeowner rel_attend left_right) ///
order(log_maison index_2017_2007 age  gender hh_income  S6  homeowner rel_attend left_right) replace star(* 0.10 ** 0.05 *** 0.01) b(2) se(2)

